<?php
/**
 * Google OAuth Callback Handler for WHMCS
 * Fixed with correct WHMCS path
 */

ini_set('display_errors', 0);
error_reporting(E_ALL);

require_once 'whmcs-google-client-helper.php';

if (!isset($_GET['code'])) {
    error_log('Google OAuth: No authorization code received');
    header('Location: https://client.thehostingking.com/clientarea/clientarea.php?incorrect=true');
    exit();
}

try {
    error_log('Google OAuth: Starting authentication process');
    
    $token_data = exchangeCodeForToken($_GET['code']);
    
    if (!$token_data || !isset($token_data['access_token'])) {
        error_log('Google OAuth: Failed to get access token');
        throw new Exception('Failed to get access token from Google');
    }
    
    error_log('Google OAuth: Access token received');
    $access_token = $token_data['access_token'];
    
    $user_info = getGoogleUserInfo($access_token);
    
    if (!$user_info || !isset($user_info['email'])) {
        error_log('Google OAuth: Failed to get user info');
        throw new Exception('Failed to get user information from Google');
    }
    
    error_log('Google OAuth: User info received - Email: ' . $user_info['email']);
    
    $email = $user_info['email'];
    $firstname = $user_info['given_name'] ?? '';
    $lastname = $user_info['family_name'] ?? '';
    $fullname = $user_info['name'] ?? '';
    
    if (empty($firstname) && !empty($fullname)) {
        $name_parts = explode(' ', $fullname, 2);
        $firstname = $name_parts[0];
        $lastname = $name_parts[1] ?? '';
    }
    
    if (empty($firstname)) {
        $firstname = explode('@', $email)[0];
    }
    
    error_log('Google OAuth: Checking if client exists');
    
    $stmt = $whmcs_pdo->prepare("SELECT * FROM tblclients WHERE email = ?");
    $stmt->execute([$email]);
    $client = $stmt->fetch();
    
    if ($client) {
        error_log('Google OAuth: Existing client - ID: ' . $client['id']);
        
        $client_id = $client['id'];
        $password_hash = $client['password'];
        
        $stmt = $whmcs_pdo->prepare("UPDATE tblclients SET lastlogin = NOW() WHERE id = ?");
        $stmt->execute([$client_id]);
        
        logWHMCSActivity($client_id, "Client logged in via Google OAuth");
        
    } else {
        error_log('Google OAuth: Creating new client');
        
        $random_password = generateRandomPassword(20);
        $password_hash = whmcsEncryptPassword($random_password);
        
        $stmt = $whmcs_pdo->prepare("
            INSERT INTO tblclients 
            (firstname, lastname, companyname, email, address1, city, state, postcode, country, 
             phonenumber, password, datecreated, lastlogin, status, language, pwresetkey) 
            VALUES (?, ?, '', ?, 'N/A', 'N/A', 'N/A', '000000', 'IN', '+91', ?, NOW(), NOW(), 'Active', 'english', '')
        ");
        
        $result = $stmt->execute([$firstname, $lastname, $email, $password_hash]);
        
        if (!$result) {
            error_log('Google OAuth: Failed to create client');
            throw new Exception('Failed to create new account');
        }
        
        $client_id = $whmcs_pdo->lastInsertId();
        error_log('Google OAuth: New client created - ID: ' . $client_id);
        
        logWHMCSActivity($client_id, "New client registered via Google OAuth");
    }
    
    error_log('Google OAuth: Setting session for client ID: ' . $client_id);
    
    $_SESSION['uid'] = $client_id;
    $_SESSION['upw'] = $password_hash;
    $_SESSION['cid'] = '';
    $_SESSION['adminid'] = 0;
    
    error_log('Google OAuth: Session set. Redirecting to client area');
    
    // FIXED: Correct WHMCS path
    header('Location: https://client.thehostingking.com/clientarea/clientarea.php');
    exit();
    
} catch (Exception $e) {
    $error_message = $e->getMessage();
    error_log('Google OAuth Error: ' . $error_message);
    
    header('Location: https://client.thehostingking.com/clientarea/clientarea.php?incorrect=true&errormessage=' . urlencode('Authentication failed'));
    exit();
}
?>